/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.figures.constraints;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import DE.siemens.ad.logo.model.CommentParameter;
import DE.siemens.ad.pdraw.figures.CommentTextFigure;
import DE.siemens.ad.pdraw.figures.constraints.FigureConstraint;
import java.awt.Dimension;

public class CommentConstraint
extends FigureConstraint {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;
    private transient String preText = null;
    private transient boolean fNoNeedRestore = false;

    public CommentConstraint() {
    }

    public CommentConstraint(Figure figure) {
        super(figure);
    }

    private CommentParameter getCommentParameter() {
        if (this.figure instanceof CommentTextFigure) {
            return ((CommentTextFigure)this.figure).getCommentParameter();
        }
        return null;
    }

    public void doDelete() {
        super.doDelete();
        if (this.getDrawing() != null) {
            this.getDrawing().remove(this.figure);
        }
    }

    protected void informNeighboursFromDelete() {
        CommentParameter par = this.getCommentParameter();
        if (par != null) {
            this.preText = par.getText();
            par.setText("");
            par.fireParameterSetEvent();
        } else {
            super.informNeighboursFromDelete();
        }
    }

    protected void informNeighboursFromRestore() {
        CommentParameter par;
        if (this.preText == null) {
            this.preText = "";
        }
        if ((par = this.getCommentParameter()) != null) {
            par.setText(this.preText);
            par.fireParameterSetEvent();
            ((TextFigure)this.figure).setText(this.preText);
        } else {
            super.informNeighboursFromRestore();
        }
    }

    public void doInsert(Drawing drawing) {
        super.doInsert(drawing);
        drawing.add(this.figure);
    }

    public synchronized void doMove(Dimension moveVector) {
        this.figure.moveBy(moveVector.width, moveVector.height);
    }

    void linkedObjectDeleted(FigureConstraint neighbour) {
        if (this.getCommentParameter() != null) {
            if (this.deleted) {
                this.fNoNeedRestore = true;
                return;
            }
            this.deleted = true;
            this.inDrawing = false;
            if (this.getDrawing() != null) {
                this.getDrawing().remove(this.figure);
            }
        } else {
            super.linkedObjectDeleted(neighbour);
        }
    }

    void linkedObjectRestored(FigureConstraint neighbour) {
        if (this.getCommentParameter() != null) {
            if (!this.deleted) {
                return;
            }
            if (this.fNoNeedRestore) {
                this.fNoNeedRestore = false;
                return;
            }
            this.deleted = false;
            this.inDrawing = true;
            if (this.getDrawing() != null) {
                this.getDrawing().add(this.figure);
            }
        } else {
            super.linkedObjectRestored(neighbour);
        }
    }

    public void updateStatus() {
        if (this.getDrawing() == null) {
            return;
        }
        CommentParameter par = this.getCommentParameter();
        if (par != null && par.getText() != null && par.getText().length() > 0) {
            this.fNoNeedRestore = false;
            this.deleted = false;
            this.inDrawing = true;
            ((TextFigure)this.figure).setText(par.getText());
            this.getDrawing().add(this.figure);
        }
    }

    public void linkedObjectMoved(FigureConstraint neighbour, Dimension moveVector) {
        CommentTextFigure commentFigure = (CommentTextFigure)this.getFigure();
        Dimension offset = null;
        if (commentFigure != null && commentFigure.getOffsetLocator() != null) {
            offset = commentFigure.getOffsetLocator().getOffset();
        }
        this.move(moveVector);
        if (offset != null) {
            commentFigure.getOffsetLocator().setOffset(offset.width, offset.height);
        }
    }

    public void undoDelete() {
        if (!this.deleted) {
            return;
        }
        this.insert(this.getDrawing());
        super.undoDelete();
        this.informNeighboursFromRestore();
    }
}

